#include <bits/stdc++.h>

#define int long long

using namespace std;

const int N = 2e5 + 5;

struct seg_tree {
    int t[4 * N];
    int query(int v, int tl, int tr, int l, int r) {
        if(tl >= l && tr <= r) {
            return t[v];
        }
        if(tl > r || tr < l) {
            return 0;
        }
        int tm = (tl + tr) / 2;
        return (query(v * 2, tl, tm,l, r) ^ query(v * 2, tm + 1, tr, l, r));
    }
    void update(int v, int tl, int tr, int index, int value) {
        if(tl == tr) {
            t[v] = value;
            return;
        }
        int tm = (tl + tr) / 2;
        if(index <= tm) {
            update(v * 2, tl, tm, index, value);
        }
        else {
            update(v * 2 + 1, tm + 1, tr, index, value);
        }
        t[v] = (t[v * 2] ^ t[v * 2 + 1]);
    }
}seg;

struct fenw {
    int t[N];
    int query(int i) {
        int ans = 0;
        while(i > 0) {
            ans += t[i];
            i -= i & - i;
        }
        return ans;
    }
    void update(int i, int v) {
        while(i < N) {
            t[i] += v;
            i += i & - i;
        }
    }
    int query(int l, int r) {
        return query(r) - query(l - 1);
    }
}fenw[61];

signed main() {
    ios::sync_with_stdio(false);
    cin.tie(0);
    int n;
    cin >> n;
    vector<int> a(n + 1);
    for(int i = 1; i <= n; i++) {
        cin >> a[i];
    }
    for(int i = 1; i <= n; i++) {
        for(int j = 0; j <= 60; j++) {
            if(a[i] & (1LL << j)) {
                fenw[j].update(i, 1);
            }
        }
    }
    int q;
    cin >> q;
    while(q--) {
        int l, r;
        cin >> l >> r;
        if(l > 0) {
            int ans = 1;
            for(int i = 0; i <= 60; i++) {
                if(fenw[i].query(l, r) > 1) {
                    ans = 0;
                }
            }
            cout << ans << "\n";
        }
        else {
            l = - l;
            for(int i = 0; i <= 60; i++) {
                if(a[l] & (1LL << i)) {
                    fenw[i].update(l, - 1);
                }
            }
            a[l] = r;
            for(int i = 0; i <= 60; i++) {
                if(a[l] & (1LL << i)) {
                    fenw[i].update(l, + 1);
                }
            }
        }
    }
}